/*==========================================================================*/
/*  OpenGL Water Demo                                                       */
/*  Author: Roman Podobedov                                                 */
/*  Email: romka@ut.ee                                                      */
/*  WEB: www.ut.ee/~romka                                                   */
/*  Date: 12 September 2000                                                 */
/*==========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "glut.h"
#include "texture.h"

#include <gl\gl.h>              // OpenGL
//#include <gl\glu.h>

#define WSIZE 84 /* Water matrix size */
#define CSPACE 2
#define PI 3.14159

int WindW, WindH;

float water[WSIZE][WSIZE];
float wt[WSIZE][WSIZE]; /* Water t parameter */

float A; /* Amplitude */

unsigned *teximage;    /* Texture data */
GLuint texture[6];     /* Textures */
extern unsigned *
read_texture(char *name, int *width, int *height, int *components);

//=================== Load Texture =========================================
void LoadTexture(char *fn, int t_num)
{
	int texwid, texht;
	int texcomps;
 
	teximage = read_texture(fn, &texwid, &texht, &texcomps);
	if (!teximage)
	{
	printf("Sorry, can't read texture file...");
	exit(0);
	}
	glBindTexture(GL_TEXTURE_2D, texture[t_num]);
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, texwid, texht, 0, GL_RGBA, GL_UNSIGNED_BYTE, teximage);


	/* Texture parameters, LINEAR scaling for better texture quality */
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR); 
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR); 

	free(teximage);
} 

/*=================== Initialization =======================================*/
void Init(void)
{
  int i, j;
  float col[4] = {0.0,0.4,0.5,1.0};

  A = 2;

  for (i=0; i<WSIZE; i++)
    for (j=0; j<WSIZE; j++)
    {
      water[i][j] = 2*sin((float)i*180/PI);
      wt[i][j] = 0;
    }

	glFogfv(GL_FOG_COLOR,col);
}


void ModifyWater(void)
{
  /* h = A*sin(2*pi*W*t)*/
  int dx, dy; /* Disturbance Point */
  float s, v, W, t;
  int i, j;

  dx = WSIZE >> 1;
  dy = WSIZE >> 1;
  W = 0.05; 
  v = -2;/* Number of waves and deepness */

  for (i=0; i<WSIZE; i++)
    for (j=0; j<WSIZE; j++)
    {
      s = sqrt((j-dx)*(j-dx) + (i-dy)*(i-dy));
		// Speed
      wt[i][j] += 0.08; 
      t = s/v;
      water[i][j] = A*sin(2*PI*W*(wt[i][j]+t));
    }
}

void Draw(void)
{
  int i, j;
  float tx, ty, td;
	static int firsttime = 1;

	glPushMatrix();

	if(firsttime){
		glGenTextures(1, texture);
		LoadTexture("water.rgb", 0);
		glEnable(GL_TEXTURE_2D);
		firsttime = 0;
	}

	glEnable(GL_TEXTURE_2D);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glBindTexture(GL_TEXTURE_2D,texture[0]);

	glTranslatef(-50,-5,-120);
    ModifyWater();
  /* Draw water */
  glBegin(GL_TRIANGLES);
  for (i=0; i<WSIZE-1; i++)
    for (j=0; j<WSIZE-1; j++)
    {
//      tx = (float)j/WSIZE;
  //    ty = (float)i/WSIZE;
      tx = (float)i/WSIZE;
      ty = (float)j/WSIZE;
      td = (float)1/WSIZE;


      glTexCoord2f(tx, ty); glVertex3f(CSPACE*i, water[i][j], CSPACE*j);
      glTexCoord2f(tx+td, ty); glVertex3f(CSPACE*(i+1), water[i+1][j], CSPACE*j);
      glTexCoord2f(tx+td, ty+td); glVertex3f(CSPACE*(i+1), water[i+1][j+1], CSPACE*(j+1));

      glTexCoord2f(tx, ty+td); glVertex3f(CSPACE*i, water[i][j+1], CSPACE*(j+1));
      glTexCoord2f(tx, ty); glVertex3f(CSPACE*i, water[i][j], CSPACE*j);
      glTexCoord2f(tx+td, ty+td); glVertex3f(CSPACE*(i+1), water[i+1][j+1], CSPACE*(j+1));


	}
  glEnd();
  glPopMatrix();
}
